function sysper(sys,E,pas)

% Olivier Pujol : septembre 2013

if (nargin~=3);error('Mauvais nombre d''arguments d''entre !');end
if (isa(sys,'cell')==0),error('Le premier argument doit tre du type ''cellule'' !');end
if (pas<=0);error('Le pas du rseau 1D doit tre positif !');end
%
%% Calcul de la matrice de transfert abcd du motif

TES=matrix(sys);

%% Extraction de la partie relle de l'lment a 

L=get(sys{1}{length(sys{1})},'Position')-get(sys{1}{2},'Position');     % Largeur du systme

if (pas-L<=0),error('[Le pas est trop petit : il doit tre suprieur  la largeur du systme !]');end

ke=get(sys{1}{2},'VecteurOndeEntree');      % Vecteur d'onde d'entre

Rea=nan(1,length(TES)); % Initialisation

for n=1:size(TES,2)
    Rea(n)=abs(real(TES{n}(1,1)*exp(j*ke*(pas-L))));    % Partie relle de a
end

clear TES

%% Partie graphique (affichage des bandes d'nergie permises)

%   Affichage du motif
xmin=get(sys{1}{2},'Position');                         % Le motif commence  la premire marche
xmax=get(sys{1}{length(sys{1})},'Position')+(pas-L);    % Le motif contient en outre la zone de sortie (Ep=cte) de longueur pas-L

pos=nan(1,length(sys{1})-1);    % Initialisation
Ep=nan(1,length(sys{1})-1);     % Initialisation
%
for i=2:length(sys{1})
    if (isa(sys{1}{i},'marche')==0),error('Mauvais type d''argument !');end
    pos(i-1)=get(sys{1}{i},'Position');
    Ep(i-1)=get(sys{1}{i},'EnergiePotentielleSortie');
end
%
pos=[xmin pos xmax];
Ep_e=sys{1}{1}(1);
Ep_s=sys{1}{1}(2);
Ep=[Ep_e Ep Ep_s];

figure
subplot(1,2,1)
hs=stairs(pos,Ep);
set(hs,'LineWidth',2,'Color','b');
axis([xmin-L xmax min(Ep) max(E)]);
set(gca,'xminortick','on','yminortick','on');
grid on;
box on
xlabel('{\itx} (nm)');
title('{Energie potentielle (eV) du motif}');
%
%   Affichage des bandes d'nergie permises
subplot(1,2,2);
plot(Rea,E);
line([1 1],[0 max(E)],'LineWidth',2,'Color','r','LineStyle','--')
axis([0 1.1 min(E) max(E)])
set(gca,'xminortick','on','yminortick','on');
grid on;
box on
xlabel('| Re\{a\} |');
ylabel('{\it E} (eV)');
title('Bandes d''nergies permises');
return;
